import cv2
import numpy as np

def getGrayFrame(cap):
    retval, input = cap.read()
    if retval == False:
        return False, np.array()
    else:
        return True, cv2.cvtColor(input, cv2.COLOR_BGR2GRAY)

if __name__ == '__main__':
    cap = cv2.VideoCapture('vtest.avi')
    #cap = cv2.VideoCapture(1)

    retval, prev_frame = getGrayFrame(cap)

    while True:
        retval, input = getGrayFrame(cap)
        if retval == False:
            break
        diff_img = np.uint8((np.int16(input) - 
                             np.int16(prev_frame)) / 2 + 128)
        prev_frame = input

        cv2.imshow("test", diff_img)
        key = cv2.waitKey(30)
        if key == ord('q'):
            break

    cv2.destroyAllWindows()
